package gov.va.vinci.dart.db.impl;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.WorkflowTemplate;
import gov.va.vinci.dart.db.WorkflowTemplateDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

import java.util.List;

import javax.persistence.Query;

public class WorkflowTemplateDAOImpl extends HibernateDAO implements WorkflowTemplateDAO {

	@Override
	public WorkflowTemplate findById(final int workflowTemplateId) throws ObjectNotFoundException {
		Query q = createQuery("from WorkflowTemplate where id=:tid");
		q.setParameter("tid", workflowTemplateId);
		return (WorkflowTemplate)q.getSingleResult();
	}


//	@Override
//	public WorkflowTemplate findByGroupId(final int groupId) throws ObjectNotFoundException {
//		Query q = createQuery("from WorkflowTemplate where reviewer.id=:gid");
//		q.setParameter("gid", groupId);
//		return (WorkflowTemplate)q.getSingleResult();
//	}

//	@Override
//	@SuppressWarnings("unchecked")
//	public List<WorkflowTemplate> listByGroupId(final int groupId) {
//		Query q = createQuery("from WorkflowTemplate where reviewer.id=:gid");
//		q.setParameter("gid", groupId);
//		return (List<WorkflowTemplate>)q.getResultList();
//	}


	@Override
	public WorkflowTemplate findByGroupIdAndWorkflowTypeId(final int groupId, final int workflowTypeId) throws ObjectNotFoundException {
		Query q = createQuery("from WorkflowTemplate where reviewer.id=:gid and workflowTypeId=:wtid");
		q.setParameter("gid", groupId);
		q.setParameter("wtid", workflowTypeId);
		return (WorkflowTemplate)q.getSingleResult();
	}


	@Override
	@SuppressWarnings("unchecked")
	public List<WorkflowTemplate> listAll() {
		Query query = createQuery("from WorkflowTemplate");
		return (List<WorkflowTemplate>)query.getResultList();
	}


	@Override
	@SuppressWarnings("unchecked")
	public List<WorkflowTemplate> listByWorkflowTypeId(final int workflowTypeId) {
		Query query = createQuery("from WorkflowTemplate where workflowTypeId=:tid");
		query.setParameter("tid", workflowTypeId);
		return (List<WorkflowTemplate>)query.getResultList();
	}
}
